//   pointData from bezier point test.x3d
//   m.miller 8.8.2023

//   note: lathe requires positive x for all points
//         prisms are plotted on z plane and extrude in y




//--- pointArray 
#declare pointDataCount = 1 ;
#declare pointArray = array mixed [pointDataCount][2] ;
#declare pointArray[0][0] = <56.000, 23.477, 12.008>  ;
#declare pointArray[0][1] = 1.000 ;


//--- prism Z
#declare bezier point test_prism_z =
prism {
    linear_spline
    0, 1, 2,
    <56.000,12.008>
    <56.000,12.008>
}


//--- prism Y
#declare bezier point test_prism_y =
prism {
    linear_spline
    0, 1, 2,
    <56.000,23.477>
    <56.000,23.477>
}

//--- lathe
#declare bezier point test_lathe =
lathe{ 
      cubic_spline
      1,
      <56.000,23.477>
      }

//--- cubic spline sweep
#declare sf=1;
#declare bezier point test_sweep_cubic =
sphere_sweep {
     cubic_spline
     3,
     <56.000, 23.477, 12.008> , 1.000*sf, 
     <56.000, 23.477, 12.008> , 1.000*sf, 
     <56.000, 23.477, 12.008> , 1.000*sf
     tolerance 0.000001
     }

//--- linear spline sweep
#declare sf=1;
#declare bezier point test_sweep_linear =
sphere_sweep {
     linear_spline
     3,
     <56.000, 23.477, 12.008> , 1.000*sf, 
     <56.000, 23.477, 12.008> , 1.000*sf, 
     <56.000, 23.477, 12.008> , 1.000*sf
     tolerance 0.000001
     }

//--- plotted spheres
#declare bezier point test_spheres =
union {
     sphere{<0,0,0>, 1.000 translate <56.000, 23.477, 12.008>  }
     }

//--- plotted cones
#declare bezier point test_cones =
union {
     }
